/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class CirculationModifier
extends Modifier
implements TooltipModifierHook,
MeleeDamageModifierHook,
BreakSpeedModifierHook,
ConditionalStatModifierHook {
    public boolean isOverworld(Level level) {
        return level.m_46472_().equals((Object)Level.f_46428_);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.CONDITIONAL_STAT});
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        Level world = player.m_20193_();
        if (this.isOverworld(world)) {
            event.setNewSpeed((float)((double)event.getNewSpeed() * (1.0 + 0.1 * (double)modifier.getLevel())));
        }
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        Level world;
        Player player = context.getPlayerAttacker();
        if (player != null && !this.isOverworld(world = player.m_20193_())) {
            return (float)((double)damage * (1.0 + 0.08 * (double)modifier.getLevel()));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_9236_();
        int level = modifier.getLevel();
        if (this.isOverworld(world)) {
            if (stat == ToolStats.DRAW_SPEED) {
                return baseValue * (1.0f + 0.3f * (float)level);
            }
        } else if (stat == ToolStats.VELOCITY) {
            return baseValue + (1.0f + 0.3f * (float)level);
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && (harvest || tool.hasTag(TinkerTags.Items.RANGED))) {
            Level world = player.m_9236_();
            if (tooltipKey == TooltipKey.SHIFT) {
                if (harvest) {
                    if (this.isOverworld(world)) {
                        TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.circulation.mining_speed"), (double)(0.1 * (double)modifier.getLevel()), tooltip);
                    } else {
                        TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.circulation.attack_damage"), (double)(0.08 * (double)modifier.getLevel()), tooltip);
                    }
                } else if (this.isOverworld(world)) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.circulation.draw_speed"), (double)(0.3 * (double)modifier.getLevel()), tooltip);
                } else {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.circulation.velocity"), (double)(0.3 * (double)modifier.getLevel()), tooltip);
                }
            }
        }
    }
}

